#ifndef C_CONNECT_THREAD_H
#define C_CONNECT_THREAD_H

/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: cConnectThread.h 1486 2009-11-02 01:36:52Z satofumi $
*/

#include <QThread>
#include <memory>
extern "C" {
#include "urg_t.h"
}


/*!
  \brief 接続用スレッドクラス
*/
class cConnectThread : public QThread
{
  Q_OBJECT;

  cConnectThread(void);
  cConnectThread(const cConnectThread& rhs);
  cConnectThread& operator = (const cConnectThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void run(void);

public:
  cConnectThread(urg_t& urg);
  ~cConnectThread(void);

  void setConnectSettings(const std::string& device, long baudrate);

signals:
  void connected(bool connected);
};

#endif /* !CONNECT_THREAD_H */
