#!/usr/bin/env python
#
# print SCIP timestamp value
#
# usage:
# python print_timestamp.py data_file

import sys

def decode(string):
    value = 0

    for ch in string:
        value <<= 6
        value &= ~0x3f
        value |= ord(ch) - 0x30

    return value


file = sys.argv[1]
pre_line = ''
pre_timestamp = -1
for line in open(file):
    if pre_line == '99b':
        timestamp_string = line[:-2] # ignore checksum
        timestamp = decode(timestamp_string)
        print str(timestamp) + "(" + str(timestamp - pre_timestamp) + ")"
        pre_timestamp = timestamp

    pre_line = line[:-1]
