#ifndef QRK_SERIAL_CONNECTION_WIDGET_H
#define QRK_SERIAL_CONNECTION_WIDGET_H

/*!
  \file
  \brief 接続管理ウィジット

  \author Satofumi KAMIMURA

  $Id: SerialConnectionWidget.h 1977 2012-04-05 08:04:51Z satofumi $
*/

#include "ui_SerialConnectionWidgetForm.h"
#include <memory>


namespace qrk
{
  class SerialConnectionWidget :
    public QWidget, private Ui::SerialConnectionWidgetForm
  {
    Q_OBJECT;

  public:
    SerialConnectionWidget(QWidget* parent = 0);
    ~SerialConnectionWidget(void);

    void setConnected(bool connected);
    bool isConnected(void) const;

    void setDevices(const std::vector<std::string>& devices);
    std::vector<std::string> devices(void);

    void setEnabled(bool enable);
    void setFocus(void);

  signals:
    void connectRequest(bool connection, const std::string& device);
    void rescanRequest(void);

  private slots:
    void connectPressed(bool checked);
    void rescanPressed(void);

  private:
    SerialConnectionWidget(const SerialConnectionWidget& rhs);
    SerialConnectionWidget& operator = (const SerialConnectionWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /*! QRK_SERIAL_CONNECTION_WIDGET_H */
