/*!
  \file
  \breif URG のデータを記録するツール

  \author Satofumi KAMIMURA

  $Id: main.cpp 1981 2012-04-05 17:22:40Z satofumi $
*/

#include "UrgRecorderWidget.h"
#include <QApplication>
#include <QTranslator>


int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    bool record_intensity_ = false;
    for (int i = 1; i < argc; ++i) {
        if (! strcmp(argv[i], "-i")) {
            record_intensity_ = true;
        }
    }

    // ロケールの適用
    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load("UrgRecorder_" + locale);
    app.installTranslator(&translator);

    // アプリケーションの起動
    UrgRecorderWidget widget;
    if (record_intensity_) {
        widget.setIntensityMode();
    }
    widget.show();
    return app.exec();
}
