#ifndef URG_RECORDER_WIDGET_H
#define URG_RECORDER_WIDGET_H

/*!
  \file
  \brief URG データの記録ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgRecorderWidget.h 1982 2012-04-05 17:24:02Z satofumi $
*/

#include "ui_UrgRecorderWidgetForm.h"
#include <memory>


class UrgRecorderWidget : public QWidget, private Ui::UrgRecorderWidgetForm
{
    Q_OBJECT;

public:
    UrgRecorderWidget(QWidget* parent = 0);
    ~UrgRecorderWidget(void);

    void setIntensityMode(void);

private slots:
    void closeEvent(QCloseEvent* event);
    void rescanPressed(void);
    void connectPressed(bool connection, const std::string& device);
    void connectPressed(bool connection, const std::string& address,
                        unsigned short port);
    void recordPressed(void);
    void cancelPressed(void);
    void timesChanged(int times);
    void recordData(void);
    void rawButtonChanged(bool checked);
    void changeButtonPressed(void);

private:
    UrgRecorderWidget(const UrgRecorderWidget& rhs);
    UrgRecorderWidget& operator = (const UrgRecorderWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
};

#endif /* !URG_RECORDER_WIDGET_H */
