#ifndef URG_INFORMATION_WIDGET_H
#define URG_INFORMATION_WIDGET_H

/*!
  \file
  \brief URG パラメータの表示ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgInformationWidget.h 1693 2010-02-14 01:16:38Z satofumi $
*/

#include "ui_UrgInformationWidgetForm.h"
#include <memory>


class UrgInformationWidget
  : public QWidget, private Ui::UrgInformationWidgetForm
{
  Q_OBJECT;

public:
  UrgInformationWidget(QWidget* parent = 0);
  ~UrgInformationWidget(void);

private slots:
  void rescanPressed(void);
  void connectPressed(bool connection, const std::string& device);
  void saveLog(void);

private:
  UrgInformationWidget(const UrgInformationWidget& rhs);
  UrgInformationWidget& operator = (const UrgInformationWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !URG_INFORMATION_WIDGET_H */
