#ifndef INPUT_WIDGET_H
#define INPUT_WIDGET_H

/*!
  \file
  \brief SCIP 文字列を入力し、結果を表示するフォーム

  \author Satofumi KAMIMURA

  $Id: InputWidget.h 1779 2010-04-15 03:17:57Z satofumi $
*/

#include "ui_InputWidgetForm.h"
#include <memory>


class InputWidget : public QWidget, private Ui::InputWidgetForm
{
  Q_OBJECT;

public:
  InputWidget(QWidget* parent = 0);
  ~InputWidget(void);

private slots:
  void inputChanged(const QString& text);

private:
  InputWidget(const InputWidget& rhs);
  InputWidget& operator = (const InputWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !INPUT_WIDGET_H */
