#ifndef URG_STATE_WIDGET_H
#define URG_STATE_WIDGET_H

/*!
  \file
  \brief URG 状態の表示ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgStateWidget.h 994 2009-06-13 09:29:40Z satofumi $

  \todo 切断したのが描画中の URG でなければ、DrawWidget を閉じないようにする
*/

#include "ui_UrgStateWidgetForm.h"
#include <memory>

class MultiUrgViewerWidget;


class UrgStateWidget : public QWidget, private Ui::UrgStateWidgetForm
{
  Q_OBJECT;

  UrgStateWidget(const UrgStateWidget& rhs);
  UrgStateWidget& operator = (const UrgStateWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectDevice(bool connection, const std::string& device);
  void captureHandler(void);
  void setViewer(void);

public:
  UrgStateWidget(MultiUrgViewerWidget* parent = 0);
  ~UrgStateWidget(void);

  void setDevices(const std::vector<std::string>& devices);
  std::string device(void) const;
  bool isConnected(void) const;

signals:
  void deleteUrgState(UrgStateWidget* widget);
};

#endif /* !URG_STATE_WIDGET_H */
