/*!
  \file
  \brief 受信割合の表示ウィジット

  \author Satofumi KAMIMURA

  $Id: DropRateWidget.cpp 1473 2009-11-01 01:21:06Z satofumi $
*/

#include "DropRateWidget.h"
#include "DetectOS.h"
#include <cstdio>

using namespace std;

#if defined(MSC)
#define snprintf _snprintf
#endif


struct DropRateWidget::pImpl
{
  DropRateWidget* widget_;


  pImpl(DropRateWidget* widget) : widget_(widget)
  {
  }


  void initializeForm(void)
  {
    setEnabled(false);
  }


  void setEnabled(bool enable)
  {
    if (! enable) {
      widget_->value_label_->setText("---");
    }
    widget_->value_label_->setEnabled(enable);
    widget_->percent_label_->setEnabled(enable);
  }
};


DropRateWidget::DropRateWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);
  pimpl->initializeForm();
}


DropRateWidget::~DropRateWidget(void)
{
}


void DropRateWidget::setEnabled(bool enable)
{
  pimpl->setEnabled(enable);
}


void DropRateWidget::setDropRate(size_t percent)
{
  enum { BufferSize = 4 };
  char buffer[BufferSize];
  snprintf(buffer, BufferSize, "%d", percent);
  pimpl->widget_->value_label_->setText(buffer);
}
