#ifndef RAILS_3D_WINDOW_H
#define RAILS_3D_WINDOW_H

/*!
  \file
  \brief メインフォーム管理

  \author Satofumi KAMIMURA

  $Id: Moving3DWindow.h 1970 2011-11-09 06:53:29Z satofumi $
*/

#include "ui_Moving3DWindowForm.h"
#include <memory>


class Moving3DWindow : public QMainWindow, private Ui::Moving3DWindowForm
{
  Q_OBJECT;

  Moving3DWindow(const Moving3DWindow& rhs);
  Moving3DWindow& operator = (const Moving3DWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  void changeObstacleLabel(bool detected);

private slots:
  void rescanPort(void);
  void record(void);
  void stop(void);
  void recordCaptureData(void);
  void front(void);
  void overview(void);
  void rescanArea(void);
  void redraw(void);
  void play(void);
  void pause(void);
  void play_stop(void);
  void readPlayData(void);

  void initializeView(void);
  void pauseAndPlay(void);
  void initializeZoom(void);
  void zoomIn(void);
  void zoomOut(void);
  void changeZoom(int value);
  void updateDrawPeriod(double value);
  void playFileLoad(void);

  void viewUp(void);
  void viewDown(void);
  void viewLeft(void);
  void viewRight(void);

  void aboutApplication(void);

public:
  Moving3DWindow(void);
  ~Moving3DWindow(void);
};


#endif /* !RAILS_3D_WINDOW_H */
