#ifndef LINE_TYPES_H
#define LINE_TYPES_H

/*!
  \file
  \brief 直線の型定義

  \author Satofumi KAMIMURA

  $Id: LineTypes.h 1970 2011-11-09 06:53:29Z satofumi $
*/

#include "Point.h"
#include "Angle.h"


namespace qrk
{
  /*!
    \brief 線分の型定義
  */
  template<class T>
  class Line
  {
  public:
    Point<T> start;
    Point<T> end;


    Line(const Point<T>& start_, const Point<T>& end_)
      : start(start_), end(end_)
    {
    }


    Line(void)
    {
    }

    // !!!
  };
}

#endif /* !LINE_TYPES_H */
