/*!
  \file
  \brief Lua への geometry モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGeometry.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindGeometry.h"
#include "Point.h"
#include "Point3d.h"
#include "Rect.h"
#include "Position.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGeometry(lua_State* L)
{
    module(L)
        [
         class_<Point<long> >("Point")
         .def(constructor<long, long>())
         .def_readwrite("x", &Point<long>::x)
         .def_readwrite("y", &Point<long>::y),

         class_<Point<double> >("fPoint")
         .def(constructor<double, double>())
         .def_readwrite("x", &Point<double>::x)
         .def_readwrite("y", &Point<double>::y),

         class_<Point3d<long> >("Point3d")
         .def(constructor<long, long, long>())
         .def_readwrite("x", &Point3d<long>::x)
         .def_readwrite("y", &Point3d<long>::y)
         .def_readwrite("z", &Point3d<long>::z),

         class_<Rect<long> >("Rect")
         .def(constructor<long, long, long, long>())
         .def_readwrite("x", &Rect<long>::x)
         .def_readwrite("y", &Rect<long>::y)
         .def_readwrite("w", &Rect<long>::w)
         .def_readwrite("h", &Rect<long>::h),

         class_<Rect<double> >("fRect")
         .def(constructor<double, double, double, double>())
         .def_readwrite("x", &Rect<double>::x)
         .def_readwrite("y", &Rect<double>::y)
         .def_readwrite("w", &Rect<double>::w)
         .def_readwrite("h", &Rect<double>::h),

         class_<Position<long> >("Position")
         .def(constructor<long, long, Angle>())
         .def_readwrite("x", &Position<long>::x)
         .def_readwrite("y", &Position<long>::y)
         .def_readwrite("angle", &Position<long>::angle)
         .def("to_deg", &Position<long>::to_deg)
         .def("to_rad", &Position<long>::to_rad),

         class_<Angle>("Angle"),

         def("deg", deg),
         def("rad", rad)
         ];
}
