#ifndef UTF8_H
#define UTF8_H

/*!
  \file
  \brief UTF-8 文字列の操作クラス

  \author Satofumi KAMIMURA

  $Id: Utf8.h 1823 2010-05-11 22:11:47Z satofumi $
*/

#include <string>
#include <memory>


namespace qrk
{
    //! UTF-8 文字列の操作クラス
    class Utf8
    {
        Utf8(void);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;

    public:
        /*!
          \brief コンストラクタ

          \param[in] utf8_text UTF-8 として格納する文字列
        */
        Utf8(const std::string& utf8_text);

        Utf8(const Utf8& rhs);
        Utf8& operator = (const Utf8& rhs);
        ~Utf8(void);

        bool empty(void);
        void clear(void);
        size_t size(void) const;

        unsigned long ch(size_t index) const;
        unsigned short operator[](size_t index);

        std::string toStdString(void);

        Utf8 substr(size_t first_index, size_t n);

        void pop_back(void);

        //Utf8& substr(size_t first, size_t last = std::string::npos);
    };
}

#endif /* !UTF8_H */
