/*!
  \file
  \brief SDL_VIDEO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlVideoInit.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <SDL.h>
#include "SdlVideoInit.h"
#include "SdlInit.h"

using namespace qrk;


struct SdlVideoInit::pImpl : private SdlInit
{
    static bool initialized_;
};
bool SdlVideoInit::pImpl::initialized_ = false;


SdlVideoInit::SdlVideoInit(void) : pimpl(new pImpl)
{
    initialize();
}


SdlVideoInit::~SdlVideoInit(void)
{
    // exit() 時に SdlInit が SDL_Quit() を呼ぶので terminate() は呼び出さない
}


void SdlVideoInit::initialize(void)
{
    if (pimpl->initialized_) {
        return;
    }
    pimpl->initialized_ =
        (SDL_InitSubSystem(SDL_INIT_VIDEO) < 0) ? false : true;
}


void SdlVideoInit::terminate(void)
{
    SDL_QuitSubSystem(SDL_INIT_VIDEO);
    pimpl->initialized_ = false;
}
