#ifndef QRK_LAYER_MANAGER_H
#define QRK_LAYER_MANAGER_H

/*!
  \file
  \brief レイヤー管理

  \author Satofumi KAMIMURA

  $Id: LayerManager.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "LayerInterface.h"
#include "Point.h"


namespace qrk
{
    class Event;


    //! レイヤー管理
    class LayerManager
    {
    public:
        LayerManager(void);
        ~LayerManager(void);

        void updateEvent(void);
        void draw(void);
        void swap(void);

        void clearEvent(void);
        void insertEvent(Event* event);
        void removeEvent(Event* event);

        void clear(void);
        void push_front(LayerInterface* layer);
        void push_back(LayerInterface* layer);
        void remove(LayerInterface* layer);

        static Point<long> cursor(void);

    private:
        LayerManager(const LayerManager& rhs);
        LayerManager& operator = (const LayerManager& rhs);

        struct pImpl;
        pImpl* pimpl;
    };
}

#endif /* !QRK_LAYER_MANAGER_H */
