/*!
  \file
  \brief 位置揃え用の関数

  \author Satofumi KAMIMURA

  $Id: AlignUtils.cpp 1811 2010-04-30 16:12:05Z satofumi $

  \todo 重複が気になるなら、実装をテンプレートにして共通にする
*/

#include "AlignUtils.h"
#include "Component.h"
#include "Surface.h"

using namespace qrk;


long qrk::left(const Component& component, long x)
{
    static_cast<void>(component);
    return x;
}


long qrk::center(const Component& component, long x)
{
    long width = component.rect().w;
    return x - (width / 2);
}


long qrk::right(const Component& component, long x)
{
    long width = component.rect().w;
    return x - width;
}


long qrk::top(const Component& component, long y)
{
    static_cast<void>(component);
    return y;
}


long qrk::middle(const Component& component, long y)
{
    long height = component.rect().h;
    return y - (height / 2);
}


long qrk::bottom(const Component& component, long y)
{
    long height = component.rect().h;
    return y - height;
}


long qrk::left(const Surface& surface, long x)
{
    static_cast<void>(surface);
    return x;
}


long qrk::center(const Surface& surface, long x)
{
    long width = surface.rect().w;
    return x - (width / 2);
}


long qrk::right(const Surface& surface, long x)
{
    long width = surface.rect().w;
    return x - width;
}


long qrk::top(const Surface& surface, long y)
{
    static_cast<void>(surface);
    return y;
}


long qrk::middle(const Surface& surface, long y)
{
    long height = surface.rect().h;
    return y - (height / 2);
}


long qrk::bottom(const Surface& surface, long y)
{
    long height = surface.rect().h;
    return y - height;
}
