/*!
  \file
  \brief 歩行時データの記録と再生用

  \author Satofumi KAMIMURA

  $Id: plotFoot.cpp 1221 2009-08-15 00:02:48Z satofumi $
*/

#include "mUrgCtrl.h"
#include "ticks.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  const char device[] = "/dev/ttyACM0";

  mUrgCtrl urg(argc, argv);
  if (! urg.connect(device)) {
    cout << "UrgCtrl::connect: " << urg.what() << endl;
    return 1;
  }

  // データを指定秒数だけ取得
  enum { CaptureSecond = 10 };
  int first_ticks = ticks();
  vector<long> data;
  while ((ticks() - first_ticks) < (CaptureSecond * 1000)) {
    urg.capture(data);
  }

  return 0;
}
