#ifndef QRK_TIMESTAMPED_POSITION_H
#define QRK_TIMESTAMPED_POSITION_H

/*!
  \file
  \brief タイムスタンプ付きの位置管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Position.h"
#include <memory>


namespace qrk
{
    class TimestampedPosition
    {
    public:
        TimestampedPosition(void);
        ~TimestampedPosition(void);

        void addPosition(const Position<long>& position, long timestamp);
        Position<long> position(long timestamp) const;

    private:
        TimestampedPosition(const TimestampedPosition& rhs);
        TimestampedPosition& operator = (const TimestampedPosition& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_TIMESTAMPED_POSITION_H */
