#ifndef QRK_TIMESTAMP_MANAGER_H
#define QRK_TIMESTAMP_MANAGER_H

/*!
  \file
  \brief タイムスタンプ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace qrk
{
    class Timestamp;


    class TimestampManager
    {
    public:
        TimestampManager(void);
        ~TimestampManager(void);

        void add(Timestamp* object);
        void remove(Timestamp* object);

        void setTimestamp(long timestamp);
        long timestamp(Timestamp* object);

        long timestamp(Timestamp* object, long raw_timestamp);

    private:
        TimestampManager(const TimestampManager& rhs);
        TimestampManager& operator = (const TimestampManager& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_TIMESTAMP_MANAGER_H */
