/*!
  \example system/samples/batteryStateSample.cpp BatteryState の動作サンプル

  \author Satofumi KAMIMURA

  $Id: batteryStateSample.cpp 1597 2010-01-03 02:36:41Z satofumi $
*/

#include "BatteryState.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  BatteryState battery;

  if (! battery.isAvailable()) {
    cout << "BatteryState is not available." << endl;
    return 1;
  }

  cout << "charging : " << boolalpha << battery.isCharging() << endl;
  cout << "percent  : " << battery.remainingPercent() << endl;
  cout << "time     : " << battery.remainingSecond() << endl;

  return 0;
}
