#ifndef QRK_BATTERY_STATE_H
#define QRK_BATTERY_STATE_H

/*!
  \file
  \brief PC バッテリー状態の取得

  \author Satofumi KAMIMURA

  $Id: BatteryState.h 1949 2011-05-06 07:18:01Z satofumi $
*/

#include <memory>
#include <cstddef>


namespace qrk
{
    //! PC バッテリー状態の取得
    class BatteryState
    {
    public:
        BatteryState(void);
        ~BatteryState(void);


        /*!
          \brief バッテリー状態が取得可能か

          \retval true 取得可能
          \retval false システムからバッテリー状態を取得できない
        */
        bool isAvailable(void) const;


        /*!
          \brief 充電中か

          \retval true 充電中
          \retval false 放電中
        */
        bool isCharging(void) const;


        /*!
          \brief バッテリー充電率

          \return バッテリー充電率 [%]
        */
        size_t remainingPercent(void) const;


        /*!
          \brief バッテリーの推定残り時間

          \return バッテリーの推定残り時間 [sec]
        */
        size_t remainingSecond(void) const;

    private:
        BatteryState(const BatteryState& rhs);
        BatteryState& operator = (const BatteryState& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_BATTERY_STATE_H */
