/*!
  \file
  \brief 環境の計測サンプル

  \author Satofumi KAMIMURA

  $Id: scanSample.cpp 1534 2009-11-18 09:32:05Z satofumi $
*/

#include "qrk_main.h"
#include "SimulationWindow.h"
#include "mUrgDevice.h"
#include <QApplication>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  mUrgDevice urg;
  if (! urg.connect("/dev/ttyACM0")) {
    cout << "UrgDrive::connect(): " << urg.what() << endl;
    return 1;
  }
  //urg.setSkipLines(2);

  urg.setRequestMode(UrgDevice::GD_Capture);

  cout << "capture." << endl;
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    vector<long> data;
    long timestamp = 0;
    urg.requestData();

    if (urg.receiveData(data, &timestamp)) {
      cout << "timestamp = " << timestamp << " [msec]"<< endl;
      size_t n = data.size();
      for (size_t j = 0; j < n; ++j) {
        cout << data[j] << ", ";
      }
      cout << endl;
    } else {
      cout << "UrgDevice::receiveData: no data: " << urg.what() << endl;
    }
  }

  return 0;
}
