/*!
  \file
  \brief Lua スクリプトの利用サンプル

  \author Satofumi KAMIMURA

  $Id: luaSample.cpp 1364 2009-10-03 08:31:01Z satofumi $
*/

#include "qrk_main.h"
#include "luabindInit.h"
#include "LuaHandler.h"
#include "luabindSystem.h"
#include "luabindGeometry.h"
#include "luabindBeegoDrive.h"
#include "luabindUrgDistance.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  lua_State* L = luabindInit();
  //LuaHandler::dofile(L, "strict.lua");

  luabindBeegoDrive(L);
  luabindUrgDistance(L);

  return LuaHandler::dofile(L, "luaSample.lua");
}
