-- シミュレーションの設定ファイル
-- Satofumi KAMIMURA
-- $Id: simulation_settings.lua 1690 2010-02-13 02:07:59Z satofumi $


-- 利用デバイスの初期化
DeviceManager():createDevice("/dev/ttyUSB0", "BeegoDrive", "run")


-- デバイスを起動
DeviceManager():device("run"):activate()


-- デバイス位置を設定
local run = DeviceManager():model("run")
run:setPosition(Position(0, 0, deg(0)), nil, false)


-- カメラ視点を設定
CameraViewManager():setInitialView(0.0, 0.0, 3.0, deg(0), deg(0), deg(0))


-- カメラ視点をロボット位置に追従させるためのイベント関数
local camera_view = CameraViewManager()
function camera_function()
   local position = run:position()
   camera_view:setBaseView(position.x / 1000.0, position.y / 1000.0, 0.0,
                           deg(0), deg(0), deg(0))
end

-- !!! ここのコメントを外すと、よく落ちる
-- !!! また、障害物が消えたりする
--DeviceManager():createEvent(camera_function, "camera")	


-- 障害物を配置
local box = Box(300, 300, 300, 1.0)
box:setPosition(Position(500, 500, deg(0)), nil, false)
