#ifndef QRK_URG_MODEL_H
#define QRK_URG_MODEL_H

/*!
  \file
  \brief URG の ODE 用モデル

  \author Satofumi KAMIMURA

  $Id: UrgModel.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Position.h"
#include "Point3d.h"
#include <ode/ode.h>
#include <memory>


namespace qrk
{
  class OdeModel;


  //! URG の ODE 用モデル
  class UrgModel
  {
  public:
    typedef enum {
      URG_04LX,
      UTM_30LX,
    } SensorType;

    UrgModel(void);
    ~UrgModel(void);

    void setSensorType(SensorType type);

    void activate(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model, bool fixed);
    Position<long> position(void) const;

    void setPosition3d(const Point3d<long>& position,
                       double ax, double ay, double az,
                       const Angle& angle,
                       OdeModel* model, bool fixed);
    void position3d(long& px, long& py, long& pz,
                    double& dx, double& dy, double& dz) const;

    dBodyID objectId(void) const;

    void setLaser(long* buffer, double radian, long max_length);

    // !!! 指定した範囲の計測を行う
    // !!! 部分

    // !!! 計測済みの距離を返す
    // !!! 一括

  private:
    UrgModel(const UrgModel& rhs);
    UrgModel& operator = (const UrgModel& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_URG_MODEL_H */
