/*!
  \file
  \brief 物体の操作

  \author Satofumi KAMIMURA

  $Id: Obstacle_device.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "Obstacle_device.h"
#include <cstring>
#include <cstdlib>

using namespace qrk;


struct Obstacle_device::pImpl
{
  size_t interval_msec_;


  pImpl(const char* script_file) : interval_msec_(1)
  {
    (void)script_file;
    // !!! スクリプトの task_initialize() 関数を呼び出す
  }
};


Obstacle_device::Obstacle_device(const char* script_file)
  : pimpl(new pImpl(script_file))
{
}


Obstacle_device::~Obstacle_device(void)
{
}


void Obstacle_device::setParameter(const char* type, const char* parameter)
{
  if (! strcmp(type, "interval")) {
    pimpl->interval_msec_ = strtol(parameter, 0, 10);
  }
}


void Obstacle_device::activate(void)
{
  // 実装しない
}


void Obstacle_device::execute(void)
{
  // !!! おそらく、ここで呼び出すスクリプトでコルーチンを呼び出す
  // !!! コルーチンの処理を確認してから実装する

  // !!! または、動作させるオブジェクト毎にこのオブジェクトを登録してもよい


  // !!! スクリプトの task_yeild() 関数を呼び出す
}


size_t Obstacle_device::nextExecuteInterval(void) const
{
  return pimpl->interval_msec_;
}
