/*!
  \file
  \brief ODE の補助

  \author Satofumi KAMIMURA

  $Id: OdeHandler.cpp 1150 2009-07-17 11:02:10Z satofumi $
*/

#include "OdeHandler.h"

using namespace qrk;


namespace
{
  class OdeInit
  {
  public:
    OdeInit(void)
    {
      dInitODE();
    }
  };
}


struct OdeHandler::pImpl : private OdeInit
{
  dWorldID world_;
  dSpaceID space_;
  dJointGroupID contact_group_;
  dGeomID ground_;


  pImpl(void)
    : world_(dWorldCreate()), space_(dHashSpaceCreate(0)),
      contact_group_(dJointGroupCreate(0)),
      ground_(dCreatePlane(space_, 0, 0, 1, 0))
  {
    dWorldSetGravity(world_, 0.0, 0.0, -9.8);
    dWorldSetCFM(world_, 0.0001);
  }


  ~pImpl(void)
  {
    dSpaceDestroy(space_);
    dWorldDestroy(world_);

    dCloseODE();
  }


  static pImpl* object(void)
  {
    static pImpl singleton_object;
    return &singleton_object;
  }
};


OdeHandler::OdeHandler(void) : pimpl(pImpl::object())
{
}


OdeHandler::~OdeHandler(void)
{
}


dWorldID OdeHandler::world(void)
{
  return pimpl->world_;
}


dSpaceID OdeHandler::space(void)
{
  return pimpl->space_;
}


dGeomID OdeHandler::ground(void)
{
  return pimpl->ground_;
}


dJointGroupID OdeHandler::contactGroup(void)
{
  return pimpl->contact_group_;
}
