/*!
  \example cmt_blink.c CMT を用いた LED 点滅サンプル

  \author Satofumi KAMIMURA

  $Id: cmt_blink.c 1650 2010-01-27 23:20:39Z satofumi $
*/

#include "cmt_control.h"
#include "led_control.h"
#include "imask_control.h"


static void timer_handler(void)
{
  static int msec = 0;
  static bool led_light = true;

  led_set(1, led_light);

  if (++msec > 500) {
    msec = 0;
    led_light = ! led_light;
  }
}


static void wait(void)
{
  volatile int i;

  for (i = 0; i < 1400000; ++i) {
    ;
  }
}


int main(void)
{
  led_initialize();
  cmt_initialize(6);

  imask_setMaskLevel(0);

  cmt_setInterval(1000, timer_handler);
  cmt_start();

  while (1) {
    led_set(0, true);
    wait();

    led_set(0, false);
    wait();
  }
}
