/*!
  \file
  \brief 割り込みマスクの設定

  \author Satofumi KAMIMURA

  $Id: imask_control.c 1633 2010-01-19 07:09:49Z satofumi $
*/

#include "imask_control.h"


void imask_setMaskLevel(unsigned char level)
{
  unsigned short sr_register;

  level <<= 4;
  level &= 0x000000f0;

  asm("stc sr, %0":"=r"(sr_register):);

  sr_register &= ~0x000000f0;
  sr_register = sr_register | level;

  asm("ldc %0, sr"::"r"(sr_register));
}


unsigned char imask_maskLevel(void)
{
  unsigned long mask;

  asm("stc sr, %0": "=r"(mask):);
  mask &= 0x000000f0;
  mask >>= 4;

  return mask;
}
