/*!
  \file
  \brief タイマー制御

  \author Satofumi KAMIMURA

  $Id: cmt_control.c 1932 2010-10-02 21:46:01Z satofumi $
*/

#include "cmt_control.h"
#include "cpu_aki_sh7125.h"
#include <7125S.H>
#include <stddef.h>


//! タイムアウト時に呼び出す関数
typedef void (*callback_t)(void);


static callback_t function_ = NULL;


void cmt_initialize(unsigned char priority)
{
  // スタンバイ解除
  STB.CR4.BYTE &= ~0x20;

  // タイマーの停止
  CMT.CMSTR.WORD &= ~0x0001;

  // 割り込み優先度の登録
  INTC.IPRJ.WORD &= ~0xf000;
  INTC.IPRJ.WORD |= (unsigned short)(priority) << 12;

  // 割り込み設定、クロック分周の設定
  CMT0.CMCSR.WORD &= ~0x0080;
  CMT0.CMCSR.WORD |= 0x0040;
}


void cmt_setInterval(int usec, void (*function)(void))
{
  function_ = function;
  CMT0.CMCOR = (usec * P_MHz) >> (10 + 3);
}


void cmt_start(void)
{
  CMT0.CMCNT = 0;
  CMT.CMSTR.WORD |= 0x0001;
}


void cmt_stop(void)
{
  CMT.CMSTR.WORD &= ~0x0001;
}


#pragma interrupt
void cmi0(void)
{
  if (function_) {
    function_();
  }

  CMT0.CMCSR.WORD &= ~0x0080;
}
