#ifndef SCI_CTRL_H
#define SCI_CTRL_H

/*!
  \file
  \brief SCI の初期化

  \author Satofumi KAMIMURA

  $Id: sci_control.h 1504 2009-11-10 23:12:50Z satofumi $
*/

//#define SCI_USE_INTERRUPT        // 送受信に割り込みを用いる


enum {
  // SCI
#ifndef SCI_BUFFER_SIZE_SHIFT
  SCI_BUFFER_SIZE_SHIFT = 9,
#endif
  SCI_BUFFER_SIZE = 1 << SCI_BUFFER_SIZE_SHIFT,
};


typedef enum {
  SCI_0 = 0,
  SCI_1 = 1,
} sci_port;


extern void sci_initialize(sci_port port, int level);
extern int sci_write(sci_port port, const char *data, int size);
extern int sci_read(sci_port port, char *buffer, int size);
extern int sci_readable(sci_port port);
extern void sci_stop(sci_port port);
extern int sci_isFlushed(sci_port port);

#endif /* !SCI_CTRL_H */
