/*
  ̃O[oǗ
  Satofumi KAMIMURA
  $Id: propertyInfo.cpp 528 2009-01-30 12:40:15Z satofumi $
*/

#include "propertyInfo.h"
#include "fileUtils.h"
#include "detect_os.h"
#include <cstdlib>


PropertyInfo::PropertyInfo(void)
  : before_read(true), file_name(""), read_fail(false) {
}


PropertyInfo::~PropertyInfo(void) {
}


bool PropertyInfo::load(const char* fname, const char* path[]) {

  file_name = VXV::searchFile(fname, path);
  if (!file_name.empty()) {
    return firstRead();
  }

  int last_index = 0;
  while (path[++last_index] != NULL)
    ;
  --last_index;
  file_name = std::string(path[last_index]) + "/" + fname;
  firstRead();
  return false;
}


bool PropertyInfo::firstRead(void) {
  if (!before_read) {
    return false;
  }

  // ݒt@CJAݒǂݏo
  fd.open(file_name.c_str(), std::ios::in);
  evaluate();
  fd.close();

  before_read = false;
  if (read_fail) {
    // !!! Beego  TTF ̐ݒ肪邽
    //save();
    read_fail = false;
  }
  return true;
}


void PropertyInfo::save(void) {
  before_read = false;

  // ݒt@CJ
  for (int i = 0; i < 2; ++i) {
    fd.open(file_name.c_str(), std::ios::out);
    if (fd.is_open()) {
      break;
    }
    if (i > 0) {
      return;
    }
    VXV::createDirs(file_name.substr(0, file_name.find_last_of('/')));
  }

  evaluate();
  fd.close();
}


void PropertyInfo::value(int* int_num, const char* key, int def_num) {
  if (!fd.is_open()) {
    *int_num = def_num;

  } else if (before_read) {
    // ǂݏo
    std::string key_actual;
    fd >> key_actual;
    // key ɂ锻
    if (key_actual.compare(key)) {
      *int_num = def_num;
      read_fail = true;

    } else {
      std::string line;
      getline(fd, line);
      *int_num = atoi(line.c_str());
    }
  } else {
    // 
    fd << key << ' ' << *int_num << std::endl;
  }
}


void PropertyInfo::value(std::string& str, const char* key,
			 const char* def_str) {
  if (!fd.is_open()) {
    str = def_str;

  } else if (before_read) {
    // ǂݏo
    std::string key_actual;
    fd >> key_actual;
    if (key_actual.compare(key)) {
      str = def_str;
      read_fail = true;

    } else {
      getline(fd, str);
      str.erase(0, str.find_first_not_of(" \t") + 1);
      str.erase(str.end() -1);
    }
  } else {
    // 
    fd << key << " \"" << str << '"' << std::endl;
  }
}
