/*
  ringBuffer.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: RingBufferTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "RingBufferTest.h"
#include "ringBufferTemplate.h"

CPPUNIT_TEST_SUITE_REGISTRATION(RingBufferTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(RingBufferTest, "RingBufferTest");

using namespace std;


// obt@ւ̔zuAoeXg
void RingBufferTest::fillTest(void) {

  RingBuffer<char> ringBuffer(3);
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.size());
  char expected[] = "abc";
  ringBuffer.put(expected, 3);
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.size());

  char buffer[3] = { 0, 0, 0 };
  ringBuffer.get(buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.size());

  CPPUNIT_ASSERT_EQUAL(string(expected), string(buffer, 3));
}


// Oobt@[e[g邩eXg
void RingBufferTest::rotateTest(void) {
  RingBuffer<char> ringBuffer(3);
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.size());

  ringBuffer.put("d", 1);
  CPPUNIT_ASSERT_EQUAL(2, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(1, (int)ringBuffer.size());

  ringBuffer.put("e", 1);
  CPPUNIT_ASSERT_EQUAL(1, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(2, (int)ringBuffer.size());

  char buffer[3] = { 0, 0, 0 };
  ringBuffer.get(buffer, 2);
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.size());
  CPPUNIT_ASSERT_EQUAL(string("de"), string(buffer, 2));

  ringBuffer.put("fg", 2);
  CPPUNIT_ASSERT_EQUAL(1, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(2, (int)ringBuffer.size());

  ringBuffer.get(buffer, 2);
  CPPUNIT_ASSERT_EQUAL(3, (int)ringBuffer.free_size());
  CPPUNIT_ASSERT_EQUAL(0, (int)ringBuffer.size());
  CPPUNIT_ASSERT_EQUAL(string("fg"), string(buffer, 2));
}


// obt@ȂeXg
void RingBufferTest::overflowTest(void) {
  RingBuffer<char> ringBuffer(3);
  int max = ringBuffer.free_size();
  for (int i = 0; i < 3 * max; ++i) {
    char expect = 'a' + (i % 26);
    ringBuffer.put(&expect, 1);
    char ch;
    ringBuffer.get(&ch, 1);
    CPPUNIT_ASSERT_EQUAL(expect, ch);
  }
}
