#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief Oobt@
  
  \author Satofumi KAMIMURA
  
  $Id: ringBuffer.h 286 2008-10-20 09:40:22Z satofumi $
*/


/*!
  \brief Oobt@̊Ǘ
*/
typedef struct {
  unsigned char *buf;
  int shiftLength;
  int length;
  int first;
  int last;
} ringBuffer_t;


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern void initRingBuffer(ringBuffer_t *ring,
			   unsigned char *buf, int shiftLength);
extern void clearRingBuffer(ringBuffer_t *ring);
extern int getRingFreeSize(ringBuffer_t *ring);
extern int getRingFillSize(ringBuffer_t *ring);
extern int putRingBuffer(ringBuffer_t *ring, unsigned char ch);
extern int getRingBuffer(ringBuffer_t *ring, unsigned char *ch);
extern int putRingBufferStr(ringBuffer_t *ring,
			    const unsigned char *str, int n);
extern int getRingBufferStr(ringBuffer_t *ring,
			    unsigned char *str, int n);
extern int checksumRingBuffer(ringBuffer_t *ring, int num);
extern void getRingBufferCopy(unsigned char *header,
			      ringBuffer_t *ring, int num);

END_C_DECLS;
#endif /* ! RING_BUFFER_H */
