/*
  ʐM
  Satofumi KAMIMURA
  $Id: connect_device.c 286 2008-10-20 09:40:22Z satofumi $
*/

#include "connect_device.h"
#include "tcpip_device.h"
#include "serial_device.h"

static int uid = 0;
static int ids_mode[ID_MAX];
static int id_index[ID_MAX];


int initConnectDevice(const char *devName, int baudrate, int mode) {
  ids_mode[uid] = mode;

  switch (mode) {
  case TCP_IP:
    id_index[uid] = tcpip_open(devName, baudrate);
    break;

  case SERIAL:
    id_index[uid] = serial_open(devName, baudrate);
    device_set_baudrate(id_index[uid], baudrate);
    break;

  default:
    return -1;
  }
  if (id_index[uid] < 0) {
    return id_index[uid];
  } else {
    return (uid++);
  }
}


void closeDevice(int id) {
  if (id < 0) {
    return;
  }
  switch (ids_mode[id]) {
  case TCP_IP:
    tcpip_close(id_index[id]);
    break;

  case SERIAL:
    serial_close(id_index[id]);
    break;
  }
}


int device_is_connected(int id) {
  if (id < 0) {
    return -1;
  }
  switch (ids_mode[id]) {
  case TCP_IP:
    return tcpip_is_connected(id_index[id]);
    break;

  case SERIAL:
    return serial_is_connected(id_index[id]);
    break;

  default:
    return -1;
    break;
  }
}


int device_send(int id, const char *data, int length) {
  if (id < 0) {
    return -1;
  }
  switch (ids_mode[id]) {
  case TCP_IP:
    return tcpip_send(id_index[id], data, length);
    break;

  case SERIAL:
    return serial_send(id_index[id], data, length);
    break;

  default:
    return -1;
    break;
  }
}


int device_recv(int id, char *data, int size, int timeout) {
  if (id < 0) {
    return -1;
  }
  switch (ids_mode[id]) {
  case TCP_IP:
    return tcpip_recv(id_index[id], data, size, timeout);
    break;

  case SERIAL:
    return serial_recv(id_index[id], data, size, timeout);
    break;

  default:
    return -1;
    break;
  }
}


void device_flush(int id) {
  if (id < 0) {
    return;
  }
  switch (ids_mode[id]) {
  case SERIAL:
    serial_flush(id_index[id]);
    break;
  }
}


int device_set_baudrate(int id, long baudrate) {
  if (id < 0) {
    return -1;
  }
  switch (ids_mode[id]) {
  case TCP_IP:
    return 0;
    break;

  case SERIAL:
    return serial_set_baudrate(id_index[id], baudrate);
    break;

  default:
    return -1;
    break;
  }
}
