#ifndef VELOCITY_CTRL_H
#define VELOCITY_CTRL_H

/*!
  \file
  \brief x

  \author Satofumi KAMIMURA

  $Id: velocityCtrl.h 286 2008-10-20 09:40:22Z satofumi $
*/

//#include "robotParams.h"
#include "velocityInfo.h"

#ifndef MM_STABLE_SHIFT
#define MM_STABLE_SHIFT 3
#endif
#ifndef DIV16_STABLE_SHIFT
#define DIV16_STABLE_SHIFT 5
#endif


enum {
  // 䂪ԂɂȂǂ
  CONTROL_UNSTABLE = 0,
  CONTROL_STABLE = 1,
};


/*!
  \brief x̏Ǘ
*/
typedef struct {
  int ref_vel;
  int current_vel;
  int acc;
  int current_pos;
  int circle_r;
  int stable;
} velocityCtrlInfo_t;


extern void initVelocityCtrlInfo(velocityCtrlInfo_t *velCtrl);
extern void getFirstHoldVelocity(velocityCtrlInfo_t *velCtrl, int vel);
extern int holdVelocityCtrl(velocityCtrlInfo_t *velCtrl);
extern int holdPositionCtrl(velocityCtrlInfo_t *velCtrl, int stable_shift);
extern int followLineCtrl(velocityCtrlInfo_t *velCtrl, int follow_r,
			  velocityInfo_t *velInfo, int run_crd_div16);
extern int followCircleCtrl(velocityCtrlInfo_t *velCtrl, int follow_r,
			    int x, int y, velocityInfo_t *velInfo,
			    int run_crd_div16);

#endif /* !VELOCITY_CTRL_H */
