/*
  RunCtrl ɂ鎞ԓ@\̎
  Satofumi KAMIMURA
  $Id: runTicksCtrl.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "runCtrl.h"
#include "timeUtils.h"

using namespace VXV;


void RunCtrl::initTicksInfo(void) {
  pre_module_msec = getModuleRawTicks();
  adjustOwnTicks(0);
}


unsigned long RunCtrl::getHostTicks(void) {
  return VXV::GetTicks();
}


void RunCtrl::beginTimeAdjust(void) {
}


void RunCtrl::endTimeAdjust(void) {
}


unsigned long RunCtrl::getModuleRawTicks(void) {
  unsigned long module_msec = 0;

  long first_ticks = VXV::GetTicks();
  if (recvModuleMsec(&module_msec) < 0) {
    throw RunCtrl_Exception("Transmit fail: in recvModuleMsec()");
  }
  long last_ticks = VXV::GetTicks();

  //return updateTicksDiff(module_msec);
  return module_msec + ((last_ticks - first_ticks) / 2);
}


unsigned long RunCtrl::updateTicksDiff(unsigned long ticks) {
  total_msec += ticks - pre_module_msec;
  pre_module_msec = ticks;

  return total_msec;
}
