#ifndef VXV_RUN_CTRL_H
#define VXV_RUN_CTRL_H

/*!
  \file
  \brief sNX

  \author Satofumi KAMIMURA

  $Id: runCtrl.h 439 2009-01-03 05:01:55Z satofumi $
*/

#include "runInterface.h"
#include "ticksCtrlInterface.h"
#include "structTables.h"
#include "connectionDevice.h"
#include "nodeAccess.h"
#include "timeUtils.h"
#include <list>

namespace qrk
{
  class Connection;
}


/*!
  \brief sNX
*/
namespace VXV
{
  class RunCtrl : public ObjCoordinateCtrl, public RunInterface,
                  public TicksCtrlInterface {
    friend class PacketHandleHostTest;
    friend class tRunCtrl_Simulator;
    friend class MonitorTask;

  protected:
    enum {
      SimulatorPort = 49754,
    };

    /*!
      \brief ݒ
    */
    enum Default {
      Baudrate = 115200,        /*!< ڑ{[[g */
      StraightVel = 300,        /*!< ix */
      StraightAcc = 600,        /*!< ix */
      RotateVel = 0x10000 >> 1,	/*!< ]px */
      RotateAcc = 0x10000 >> 1,	/*!< ]px */
      FollowRadius = 500,       /*!< oHǏ]̋ȗ */
    };

  private:
    qrk::Connection* con;
    nodeInfo_t* node;
    long unique_id;
    bool crd_auto;
    nodeInfo_t nodeResource;

  protected:
    VXV::Position local_offset;	/*!< {bgʒȕCp */

  private:
    std::string error_message;

    typedef struct {
      int straight_ref_vel;
      int straight_ref_acc;
      long rotate_ref_vel;
      long rotate_ref_acc;
      int follow_r;
    } runParams_t;

    enum { SEND_COMMAND_SIZE = 256 };
    typedef struct {
      VXV::Position position;
      const CoordinateCtrl* crd;
      int send_command_size;
      char send_command[SEND_COMMAND_SIZE];
    } runCommand_t;

    typedef struct {
      runParams_t params;
      runCommand_t command;
    } runState_t;

    std::list<runState_t> state_stack;

    unsigned long pre_module_msec;
    unsigned long total_msec;
    ticksInfo_t ticksInfoObj;
    ticksInfo_t& getTicksInfo(void) {
      return ticksInfoObj;
    }
    void beginTimeAdjust(void);
    void endTimeAdjust(void);

    void initRunParams(void);
    void printHelp(void);
    void printVersion(void);
    bool parseArgs(int* ret_value, int argc, char *argv[]);
    int checkVersion(void);
    void crdNortify(int state, const CoordinateCtrl* crd);
    const VXV::Position getRunCmdPos(const CoordinateCtrl* crd,
                                     const VXV::Position& position);
    void sendUpdatedPosition(const CoordinateCtrl* crd,
                             const VXV::Position& position);
    unsigned long updateTicksDiff(unsigned long ticks);
    RunCtrl(const RunCtrl& rhs);

#include "commandCtrl.h"

  protected:
    runCtrl_t* tbl;		/*!< sp[^\ */
    runCtrl_t tblResource;

    /*!
      \brief Direction l div16 pxɕϊ

      sRg[Ɋpxnۂ̕ϊɎgp

      \param t [i] px [VXV::Direction]

      \retval div16 l
    */
    int to_div16(const VXV::Direction& t);

  public:
    unsigned long getModuleRawTicks(void);

    /*!
      \brief ڑ

      ڑs

      \param conObj [i] ڑIuWFNg
      \param device [i] ڑfoCX
      \param baudrate [i] ڑ{[[g

      \retval 0 I
      \retval ߂l < 0 G[
    */
    virtual int raw_connect(qrk::Connection* conObj,
                            const char* device, long baudrate);

    /*!
      \brief zXg̃^CX^v擾
    */
    virtual unsigned long getHostTicks(void);

    /*!
      \brief 킹̏
    */
    virtual void initTicksInfo(void);

  public:
    enum {
      LineOver = +1, LineNotOver = -1,
      DefaultTimeout = -1,
    };
    CoordinateCtrl& FS;		/*!< ➑̈ʒuS̍Wn */

    /*!
      \defgroup system_grp VXeR}h
      \{
    */
    RunCtrl(void);
    virtual ~RunCtrl(void);

    const char* what(void);

    void setConnection(qrk::Connection* connection);

    virtual int connect(int argc, char *argv[]);

    virtual int connect(const char* device, long baudrate = Baudrate);

    /*!
      \brief ݒt@C̓e]Đڑs

      ݒt@Cł defaultargs ƂÕt@Ce]ĐڑsBdefaultargs t@C ./, ~/.vxv/ ƂԂɑBdefaultargs t@Cɂ́AnPsɋLqĂƁBdefaultargs  '#' s܂ł̓e͖\n
      ̃\bh́Aconnect(argc, argv) ŐڑmłȂƂɂ]

      ~/.vxv/defaultargs ̗
      \code
      # vxv2
      --run_port=/dev/ttyUSB0
      --urg_port=/dev/ttyACM0
      --urg_handstand
      \endcode

      \code
      include <runCtrl.h>

      int main(int argc, char *argv[]) {
        try {
          RunCtrl run;
	  if (run.connect(argc, argv) < 0) {
            printf("RunCtrl::connect: %s\n", run.what());
	    exit(1);
	  }
	  ...

        } chatch (std::exception& e) {
          printf("exception: %s\n", e.what());
        }
        return 0;
      }
      \endcode
    */
    virtual int connect(void);

    /*!
      \brief \Pbgɑ΂Đڑ

      TCP/IP ڑsBʐMéAsRg[ɑf[^𓯂ƂȂBV~[^ɑ΂ĐڑꍇAlbg[NzɑsRg[𐧌䂵ꍇɗp

      \param host [i] ڑzXg
      \param port [i] ڑ|[g

      \retval 0 I
      \retval ߂l < 0 G[
    */
    int connectSocket(const char* host, long port = SimulatorPort);

    virtual void disconnect(void);

    /*!
      \brief ڑĂ邩ǂԂ

      sIuWFNg|[gɑ΂ĐڑĂ邩Ԃ

      \retval true ڑĂ
      \retval false ڑĂȂ

      gp
      \code
      RunCtrl run;
      run.connect(argc, argv);
      if (!run.isConnect()) {
        printf("RunCtrl::connect: %s\n", run.what());
        exit(1);
      }
      ...
      \endcode
    */
    virtual bool isConnected(void);

    void push_runState(void);
    void pop_runState(void);


    /*!
      \brief ʐMG[̍đ񐔐ݒ

      sRg[Ƃ̒ʐMG[NꍇAPgUNVɂĉ񎸔sA{[g邩ݒ肷

      \param times [i] đ
    */
    void set_sendRetryTimes(int times);

    /*!
      \brief M̃^CAEgw

      sRg[̉ȂꍇA msec ȂΒʐMG[ƌȂݒ肷

      \param timeout [i] ^CAEg [msec]
    */
    void set_recvTimeout(int timeout = DefaultTimeout);

    /*!
      \brief msec Watch Dog Timer Ԃ̐ݒ

      sRg[́Aݒ莞Ԗɉ炩̒ʐM͂Ȃ΁A~R}h𔭍sĈȌ㓮삵ȂȂB~܂ł̃JE^́ACӂ̒ʐMR}hsRg[ɓ͂xɐݒlɃZbg

      \param msec [i] ^CAEg܂ł̎
    */
    void set_watchDogTimer(unsigned long msec);

    /*! \} */


    /*!
      \defgroup position_grp {bgʒuR}h
      \{
    */

    virtual VXV::Position3D getLocalPosition(void);
    VXV::Position getRunPosition(const CoordinateCtrl* crd = VXV::GL);
    void adjustRunPosition(const VXV::Position& position,
                           const CoordinateCtrl* crd = VXV::GL);
    void coordinateUpdateDetect(bool on);

    /*! \} */

    /*!
      \defgroup move_grp ړR}h
      \{
    */

    virtual void stop(void);
    virtual void followLine(const VXV::Position& position,
                            const CoordinateCtrl* crd = VXV::GL);
    virtual void followCircle(const VXV::Grid& center, int radius,
                              const CoordinateCtrl* crd = VXV::GL);
    void followCircleOnTangent(const VXV::Position& position, int radius,
                               const CoordinateCtrl* crd = VXV::GL);
    virtual void stopToLine(const VXV::Position& position,
                            const CoordinateCtrl* crd = VXV::GL);
    virtual void rotateToDirection(const VXV::Direction& direction,
                                   const CoordinateCtrl* crd = VXV::GL);

    virtual void rotateAngle(const VXV::Direction& direction);
    virtual void spin(const VXV::Direction& velocity);
    virtual void lastMoveCommand(const CoordinateCtrl* crd = VXV::GL);

    /*! \} */


    /*!
      \defgroup judge_grp R}h
      \{
    */

    virtual bool isStable(void);
    int getLengthToGrid(const VXV::Grid& grid,
                        const CoordinateCtrl* crd = VXV::GL);
    int getLengthToBody(const VXV::Grid& grid,
                        const CoordinateCtrl* crd = VXV::GL);
    int getLengthToLine(const VXV::Position& line,
                        const CoordinateCtrl* crd = VXV::GL);
    VXV::Direction getAngleToDirection(const VXV::Direction& t,
                                       const CoordinateCtrl* crd = VXV::GL);
    int getStraightVelDiff(int mm_vel = 0);
    VXV::Direction getRotateVelDiff(const VXV::Direction& t = VXV::Direction());

    /*! \} */


    /*!
      \defgroup parameter_grp p[^R}h
      \{
    */

    void setStraightRefVel(int mm_sec);
    void setStraightRefAcc(int mm_acc);
    void setRotateRefVel(const VXV::Direction& rotate_vel);
    void setRotateRefAcc(const VXV::Direction& rotate_acc);
    void setCurveRadius(int mm);
    int getStraightVel(void);
    VXV::Direction getRotateVel(void);
    int getCurveRadius(void);

    /*! \} */


    /*!
      \defgroup direct_grp ڐR}h
      \{
    */

    virtual void servoCtrl(bool on);

    /*!
      \brief PWM ̒ڎw

      w胂[^ɑ΂āAo͂ PWM ̃f[eB𒼐ڎw肷

      \param id [i] [^ID
      \param duty [i] PWM  [0, 255]
    */
    void setMotorPwm(int id, unsigned char duty);

    /*!
      \overload

      \param id [i] [^ID
      \param duty [i] PWM i[z
      \param num [i] [^ID 牽̃[^ PWM w肷邩
    */
    void setMotorPwm(int id, unsigned char duty[], int num);

    /*!
      \brief [^̉][h𒼐ڎw

      [^̉][hw肷Bwł][h́AFREE, CW, CWW ̂ꂩ

      \param id [i] [^ID
      \param mode [i] [^̐䃂[h

      \todo FREE ̎w肪삵ĂȂƎvA؂
    */
    void setMotorMode(int id, unsigned char mode);

    /*!
      \overload

      \param id [i] [^ID
      \param mode [i] 䃂[hi[z
      \param num [i] [^ID 牽̃[^̐䃂[hw肷邩
    */
    void setMotorMode(int id, unsigned char mode[], int num);

    /*!
      \brief GR[_x̎擾

      1 [msec]̃GR[_l̕ω(x)擾

      \param id [i] GR[_ID
      \param cnt [o] GR[_l̕ψ [1]
    */
    void getEncoderVel(int id, int *cnt);

    /*!
      \overload

      \param id [i] GR[_ID
      \param cnt [o] GR[_xi[邽߂̔z
      \param num [i] GR[_ID 牽̃GR[_x擾邩
    */
    void getEncoderVel(int id, int cnt[], int num);

    /*!
      \brief GR[_JE^l̎擾

      _ł̃GR[_JE^l擾

      \attention 擾ԊuɂẮAGR[_̃I[o[t[ołȂ

      \param id [i] GR[_ID
      \param cnt [o] GR[_̃JE^l [1]
    */
    void getEncoderValue(int id, unsigned short *cnt);

    /*!
      \overload

      \param id [i] GR[_ID
      \param cnt [o] GR[_li[邽߂̔z
      \param num [i] GR[_ID 牽̃GR[_l擾邩
    */
    void getEncoderValue(int id, unsigned short cnt[], int num);

    /*!
      \brief ԗւ̈ړx𒼐ڎw

      ԗւ̈ړx擾

      \param id [i] ԗID
      \param mm_vel [i] ԗւ̈ړx [mm/sec]
    */
    void setWheelVel(int id, int mm_vel);

    /*!
      \overload

      \param id [i] ԗID
      \param mm_vel [i] ԗւ̈ړxi[z
      \param num [i] ԗID 牽̈ړxw肷邩
    */
    void setWheelVel(int id, int mm_vel[], int num);

    /*! \} */


    /*!
      \defgroup noreset_grp ➑̈ˑ̏擾R}h
      \{
    */

    VXV::Position getNoResetRunPosition(void);
    int getBodyRotateCount(void);
    void getEncoderRotateCount(int id, int count[], int num = 1);

    /*! \} */
  };


  /*!
    \brief s䃂W[̗O
  */
  class RunCtrl_Exception : public std::exception {
    std::string error_message;

  public:

    /*!
      \addtogroup system_grp
      \{
    */

    /*!
      \brief bZ[Ww肵ėO𓊂
    */
    RunCtrl_Exception(const char* message) throw () : error_message(message){}
    virtual ~RunCtrl_Exception(void) throw () {}

    /*!
      \brief O̕Ԃ

      s䃂W[OԂR\

      gp
      \code
      include <runCtrl.h>

      int main(int argc, char *argv[]) {
        try {
          RunCtrl run;
          ...

        } chatch (std::exception& e) {
          printf("exception: %s\n", e.what());
        }
        return 0;
      }
      \endcode
    */
    virtual const char* what(void) const throw() {
      return error_message.c_str();
    }
    /*! \} */
  };
}

#endif /* !VXV_RUN_CTRL_H */
