/*
  d̏Ԃ
  Satofumi KAMIMURA
  $Id: noResetInfo.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "runCtrl.h"

using namespace VXV;


VXV::Position RunCtrl::getNoResetRunPosition(void) {
  int x = 0, y = 0, div16 = 0;
  if (recvNoResetPosition(&x, &y, &div16) < 0) {
    throw RunCtrl_Exception("Transmit fail: in recvNoResetPosition()");
  }
  return VXV::Position(x, y, VXV::Direction::rad(2.0*M_PI * div16 / 0x10000));
}


int RunCtrl::getBodyRotateCount(void) {
  int count = 0;
  if (recvBodyRotateCount(&count) < 0) {
    throw RunCtrl_Exception("Transmit fail: in recvBodyRotateCount()");
  }
  return count;
}


void RunCtrl::getEncoderRotateCount(int id, int count[], int num) {
  if (recvEncoderRotateCount(id, count, num) < 0) {
    throw RunCtrl_Exception("Transmit fail: in recvEncoderRotateCount()");
  }
}
