#ifndef RUN_SIMULATE_TEST_H
#define RUN_SIMULATE_TEST_H

/*!
  \file
  \brief runCtrl.h ̃eXg
  
  \author Satofumi KAMIMURA
  
  $Id: RunSimulateTest.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>
#include "mRunCtrl.h"

/*!
  \brief mRunCtrl ps̃R}heXg
  \todo ڑrŐؒfꂽƂɁAO𓊂邩̃eXg

  \todo judgeURGsPosition() ̃eXgŎs(݂̓RgAEg)
*/
class RunSimulateTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(RunSimulateTest);
  CPPUNIT_TEST(compileTest);
  CPPUNIT_TEST(getPositionTest);
  CPPUNIT_TEST(adjustRunPositionTest);
  CPPUNIT_TEST(judgeCtrlTest);
  CPPUNIT_TEST(followLineTest);
  CPPUNIT_TEST(stopTest);
  CPPUNIT_TEST(followCircleTest);
  CPPUNIT_TEST(followCircleOnTangentTest);
  CPPUNIT_TEST(stopToLineTest);
  CPPUNIT_TEST(turnToDirectionTest);
  CPPUNIT_TEST(rotateAngleTest);
  CPPUNIT_TEST(spinTest);
  CPPUNIT_TEST(lastMoveCommandTest);
  CPPUNIT_TEST(fsPositionTest);
  CPPUNIT_TEST(fsTurnTest);
  CPPUNIT_TEST(fsLineTest);
  CPPUNIT_TEST(multiCoordinateTest);
  CPPUNIT_TEST(adjustCrdPositionTest);
  CPPUNIT_TEST(adjustRunPositionTest2);
  CPPUNIT_TEST(CoordinateUpdateDetectTest);
  CPPUNIT_TEST_SUITE_END();

  mRunCtrl* run;

  void setURGs(CoordinateCtrl& urg1,
	       CoordinateCtrl& urg2,
	       CoordinateCtrl& urg3);
  void robotMove(void);
  void judgeURGsPosition(CoordinateCtrl& urg1,
			 CoordinateCtrl& urg2,
			 CoordinateCtrl& urg3);

public:
  void setUp(void);
  void tearDown(void);
  void compileTest(void);

  void getPositionTest(void);
  void adjustRunPositionTest(void);
  void judgeCtrlTest(void);

  void followLineTest(void);
  void stopTest(void);
  void followCircleTest(void);
  void followCircleOnTangentTest(void);
  void stopToLineTest(void);
  void turnToDirectionTest(void);
  void rotateAngleTest(void);
  void spinTest(void);
  void lastMoveCommandTest(void);

  void fsPositionTest(void);
  void fsTurnTest(void);
  void fsLineTest(void);
  void multiCoordinateTest(void);
  void adjustCrdPositionTest(void);
  void adjustRunPositionTest2(void);
  void CoordinateUpdateDetectTest(void);
};

#endif /* ! RUN_SIMULATE_TEST_H */
