/*!
  \example encoder_output.c エンコーダ値の出力サンプル

  \author Satofumi KAMIMURA

  $Id: encoder_output.c 1652 2010-01-28 13:05:59Z satofumi $
*/

#include "mtu_control.h"
#include "encoder_control.h"
#include "led_control.h"
#include "sci_control.h"
#include "sci_put.h"


static encoder_t encoder_[2];


static void wait(void)
{
  volatile int i;
  volatile int j;

  for (i = 0; i < 50000; ++i) {
    for (j = 0; j < 2; ++j) {
      encoder_update(&encoder_[j]);
    }
  }
}


static void output(void)
{
  int i;

  for (i = 0; i < 2; ++i) {
    int count = encoder_count(i);
    sci_putint(count);
    sci_puts(", ");
  }
  sci_puts("\r\n");
}


int main(void)
{
  sci_initialize(6, 38400);
  led_initialize();
  mtu_initialize();

  int i;
  for (i = 0; i < 2; ++i) {
    encoder_initialize(i, &encoder_[i]);
  }

  while (1) {
    led_set(0, true);
    led_set(1, false);
    wait();
    output();

    led_set(0, false);
    led_set(1, true);
    wait();
    output();
  }
}
