#ifndef PWM_CONTROL_H
#define PWM_CONTROL_H

/*!
  \file
  \brief PWM 制御

  \author Satofumi KAMIMURA

  $Id: pwm_control.h 1677 2010-02-07 13:59:59Z satofumi $
*/

#include "pwm_t.h"


/*!
  \brief モータ制御用の PWM を初期化
*/
extern void pwm_initialize(int id);


/*!
  \brief モータ制御用の IO 出力を設定

  \param[in] id デバイス ID
  \param[in] mode モータの制御モード
  \param[in] 0 のときに常時 L 出力、255 のときに常時 H 出力となる
*/
extern void pwm_set(int id, PwmMode mode, unsigned char duty);

#endif /* !PWM_CONTROL_H */
