/*!
  \file
  \brief 構造体オフセットの出力

  sh-elf-gdb ./dumpStruct
  target sim
  load
  run

  \author Satofumi KAMIMURA

  $Id: dumpStruct.c 1687 2010-02-11 05:26:50Z satofumi $

  \todo define マクロを用いて記述を簡略化する
*/

#include "robot_t.h"
#include <stdio.h>

// !!! 記述が面倒
//#define DUMP_OFFSET(X, Y, Z) { printf("%s, %d, %d, %s\n", "X", (void*)(&X


int main(void)
{
  volatile robot_t robot;

  printf("robot.reset, %d, %d, char\n",
         (void*)(&robot.reset) - (void*)(&robot), sizeof(char));

  // system
  printf("robot.system.reset, %d, %d, char\n",
         (void*)(&robot.system.reset) - (void*)(&robot), sizeof(char));
  printf("robot.system.major, %d, %d, unsigned char\n",
         (void*)(&robot.system.major) - (void*)(&robot), sizeof(unsigned char));
  printf("robot.system.minor, %d, %d, unsigned char\n",
         (void*)(&robot.system.minor) - (void*)(&robot), sizeof(unsigned char));
  printf("robot.system.micro, %d, %d, unsigned char\n",
         (void*)(&robot.system.micro) - (void*)(&robot), sizeof(unsigned char));

  printf("robot.system.sec, %d, %d, unsigned long\n",
         (void*)(&robot.system.sec) - (void*)(&robot), sizeof(unsigned long));
  printf("robot.system.msec, %d, %d, unsigned short\n",
         (void*)(&robot.system.msec) - (void*)(&robot), sizeof(unsigned short));

  printf("robot.system.mode, %d, %d, ControlMode\n",
         (void*)(&robot.system.mode) - (void*)(&robot), sizeof(ControlMode));

  // encoder
  printf("robot.encoder_0.reset, %d, %d, char\n",
         (void*)(&robot.encoder[0].reset) - (void*)(&robot), sizeof(char));
  printf("robot.encoder_1.reset, %d, %d, char\n",
         (void*)(&robot.encoder[1].reset) - (void*)(&robot), sizeof(char));
  // !!!

  // motor
  printf("robot.motor_0.reset, %d, %d, char\n",
         (void*)(&robot.motor[0].reset) - (void*)(&robot), sizeof(char));
  printf("robot.motor_0.gain_p, %d, %d, long\n",
         (void*)(&robot.motor[0].gain_p) - (void*)(&robot), sizeof(long));
  printf("robot.motor_0.gain_i, %d, %d, long\n",
         (void*)(&robot.motor[0].gain_i) - (void*)(&robot), sizeof(long));

  printf("robot.motor_1.reset, %d, %d, char\n",
         (void*)(&robot.motor[1].reset) - (void*)(&robot), sizeof(char));
  printf("robot.motor_1.gain_p, %d, %d, long\n",
         (void*)(&robot.motor[1].gain_p) - (void*)(&robot), sizeof(long));
  printf("robot.motor_1.gain_i, %d, %d, long\n",
         (void*)(&robot.motor[1].gain_i) - (void*)(&robot), sizeof(long));

  // wheel
  // !!!

  // body
  printf("robot.body.reset, %d, %d, char\n",
         (void*)(&robot.body.reset) - (void*)(&robot), sizeof(char));
  printf("robot.body.rotate_coeffecient, %d, %d, long\n",
         (void*)(&robot.body.rotate_coeffecient) - (void*)(&robot), sizeof(long));

  // position
  printf("robot.position.reset, %d, %d, char\n",
         (void*)(&robot.position.reset) - (void*)(&robot), sizeof(char));
  printf("robot.position.mm_0, %d, %d, long\n",
         (void*)(&robot.position.mm[0]) - (void*)(&robot), sizeof(long));
  printf("robot.position.mm_1, %d, %d, long\n",
         (void*)(&robot.position.mm[1]) - (void*)(&robot), sizeof(long));
  printf("robot.position.dir16, %d, %d, unsigned short\n",
         (void*)(&robot.position.dir16) - (void*)(&robot), sizeof(unsigned short));

  // follow_position
  printf("robot.follow_position.reset, %d, %d, char\n",
         (void*)(&robot.follow_position.reset) - (void*)(&robot), sizeof(char));
  printf("robot.follow_position.mm_0, %d, %d, long\n",
         (void*)(&robot.follow_position.mm[0]) - (void*)(&robot), sizeof(long));
  printf("robot.follow_position.mm_1, %d, %d, long\n",
         (void*)(&robot.follow_position.mm[1]) - (void*)(&robot), sizeof(long));
  printf("robot.follow_position.dir16, %d, %d, unsigned short\n",
         (void*)(&robot.follow_position.dir16) - (void*)(&robot), sizeof(unsigned short));

  // path
  printf("robot.path.reset, %d, %d, char\n",
         (void*)(&robot.path.reset) - (void*)(&robot), sizeof(char));
  printf("robot.path.reset_offset, %d, %d, char\n",
         (void*)(&robot.path.reset_offset) - (void*)(&robot), sizeof(char));
  printf("robot.path.mode, %d, %d, PathMode\n",
         (void*)(&robot.path.mode) - (void*)(&robot), sizeof(long));
  printf("robot.path.rotate_direction, %d, %d, long\n",
         (void*)(&robot.path.rotate_direction) - (void*)(&robot), sizeof(long));
  printf("robot.path.circle_radius, %d, %d, long\n",
         (void*)(&robot.path.circle_radius) - (void*)(&robot), sizeof(long));

  // follow (straight, rotate)
  printf("robot.straight.reset, %d, %d, char\n",
         (void*)(&robot.straight.reset) - (void*)(&robot), sizeof(char));
  printf("robot.straight.is_stable, %d, %d, char\n",
         (void*)(&robot.straight.is_stable) - (void*)(&robot), sizeof(char));
  printf("robot.straight.target_velocity, %d, %d, long\n",
         (void*)(&robot.straight.target_velocity) - (void*)(&robot), sizeof(long));
  printf("robot.straight.control_velocity, %d, %d, long\n",
         (void*)(&robot.straight.control_velocity) - (void*)(&robot), sizeof(long));
  printf("robot.straight.control_acceleration, %d, %d, long\n",
         (void*)(&robot.straight.control_acceleration) - (void*)(&robot), sizeof(long));


  printf("robot.rotate.reset, %d, %d, char\n",
         (void*)(&robot.rotate.reset) - (void*)(&robot), sizeof(char));
  printf("robot.rotate.is_stable, %d, %d, char\n",
         (void*)(&robot.rotate.is_stable) - (void*)(&robot), sizeof(char));
  printf("robot.rotate.target_velocity, %d, %d, long\n",
         (void*)(&robot.rotate.target_velocity) - (void*)(&robot), sizeof(long));
  printf("robot.rotate.control_velocity, %d, %d, long\n",
         (void*)(&robot.rotate.control_velocity) - (void*)(&robot), sizeof(long));
  printf("robot.rotate.control_acceleration, %d, %d, long\n",
         (void*)(&robot.rotate.control_acceleration) - (void*)(&robot), sizeof(long));

  // direct
  printf("robot.direct.reset, %d, %d, char\n",
         (void*)(&robot.direct.reset) - (void*)(&robot), sizeof(char));
  printf("robot.direct.wheel_0.target_velocity, %d, %d, long\n",
         (void*)(&robot.direct.wheel[0].target_velocity) - (void*)(&robot), sizeof(long));
  printf("robot.direct.wheel_1.target_velocity, %d, %d, long\n",
         (void*)(&robot.direct.wheel[1].target_velocity) - (void*)(&robot), sizeof(long));

  return 0;
}
