/*!
  \file
  \brief Thread sample

  \author Satofumi KAMIMURA

  $Id: urgsScan.cpp 1766 2010-04-11 07:01:11Z satofumi $
*/

#include "UrgDevice.h"
#include "Thread.h"
#include "delay.h"
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


static int thread_function(void* args)
{
  UrgDevice urg;

  const char* device = static_cast<const char*>(args);
  if (! urg.connect(device)) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  enum { CaptureTimes = 10 };
  vector<long> data;
  for (int i = 0; i < CaptureTimes; ++i) {
    data.clear();
    if (urg.capture(data)) {
      printf("%s: n = %d\n", device, data.size());
    }
    delay(1);
  }

  return 0;
}


int main(int argc, char *argv[])
{
  const char *devices[] = {
    "/dev/ttyACM0",
    "/dev/ttyACM1",
  };

  Thread *threads[2];
  for (int i = 0; i < 2; ++i) {
    threads[i] = new Thread(thread_function, const_cast<char *>(devices[i]));
    threads[i]->run();
  }

  for (int i = 0; i < 2; ++i) {
    threads[i]->wait();
  }

  return 0;
}
