/*!
  \example viewVvSample.cpp

  \brief VV データ内容の表示

  \author Satofumi KAMIMURA

  $Id: versionLines.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include <iostream>
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);

  //const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  if (! urg.connect(device)) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  // バージョン情報の出力
  vector<string> lines;
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgDevice::versionLines: " << urg.what() << endl;
    exit(1);
  }

  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }

  return 0;
}
