/*!
  \example timestamp sync sample

  \author Satofumi KAMIMURA

  $Id: timestampSync.cpp 1795 2010-04-20 20:16:19Z satofumi $
*/

#include "UrgDevice.h"
#include "ticks.h"
#include "delay.h"

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  UrgDevice urg;
  if (! urg.connect("/dev/ttyACM0")) {
    cout << "UrgDevice::connect: " << urg.what() << endl;
    return 1;
  }
  //urg.setCaptureMode(AutoCapture);

  urg.setTimestamp(ticks());
  while (true) {
    vector<long> data;
    long timestamp;
    if (urg.capture(data, &timestamp) > 0) {
      cout << timestamp << ", " << ticks() << endl;
    }
    //delay(10);
  }

  return 0;
}
