/*!
  \example laser_check.cpp

  \brief MD 後に GD 取得ができるかの動作確認用

  \author Satofumi KAMIMURA

  $Id: laser_check.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include <SDL.h>
#include <cstdlib>
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    cout << "UrgDevice::connect: " << urg.what() << endl;
    exit(1);
  }

  // MD 取得終了でレーザー消灯後に GD 取得
  urg.setCaptureMode(AutoCapture);
  urg.setCaptureTimes(1);

  vector<long> data;
  int n = urg.capture(data);
  cout << "1st: n = " << n << endl;

  urg.setCaptureMode(ManualCapture);
  n = urg.capture(data);
  cout << "2nd: n = " << n << endl;

  // MD を QT で停止させてから GD 取得
  urg.setCaptureMode(AutoCapture);
  urg.setCaptureTimes(mUrgDevice::Infinity);
  n = urg.capture(data);
  cout << "3rd: n = " << n << endl;

  urg.setCaptureMode(ManualCapture);
  n = urg.capture(data);
  cout << "4th: n = " << n << endl;

  return 0;
}
