/*!
  \example gd_check.cpp

  \brief GD 取得中にデータが受信できなくなる、という現象の再現用

  \author Satofumi KAMIMURA

  $Id: gd_check.cpp 1739 2010-03-06 07:43:32Z satofumi $

  \attention 動作確認後、削除すること
*/

#include "mUrgDevice.h"
#include "ticks.h"
#include <SDL.h>
#include <cstdlib>
#include <cassert>
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0", 115200)) {
  //if (! urg.connect("COM3", 115200)) {
    cout << "UrgDevice::connect: " << urg.what() << endl;
    exit(1);
  }

  enum {
    FirstIndex = 128,
    LastIndex = 640,
    EvaluateMinute = 30,
  };
  urg.setCaptureRange(FirstIndex, LastIndex);

  vector<long> data;
  int first_ticks = ticks();
  int counter = 0;

  while ((ticks() - first_ticks) < (EvaluateMinute * 60 * 1000)) {
    int n = urg.capture(data);
    assert(n == static_cast<int>(LastIndex + 1));

    ++counter;
    if ((counter % 10) == 0) {
      cerr << (counter / 10) << ", ";
    }
  }

  return 0;
}
