/*!
  \example gdCaptureSample.cpp

  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdScan.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  //const char device[] = "COM4";
  const char device[] = "/dev/ttyACM0";
  //const char device[] = "/dev/usb/ttyUSB0";

  mUrgDevice urg(argc, argv);

  if (! urg.connect(device)) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで指定された回数だけスキャンを行い、出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    vector<long> data;

    int n = urg.capture(data, &timestamp);

    printf("timestamp: %ld\n", timestamp);
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }
  return 0;
}
