/*!
  \example captureSample.cpp

  \brief GD, MD コマンドでのデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: captureSample.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setCaptureRange(128, 640);

  // GD コマンドで１スキャン分のデータ取得を行い、指定回数だけ出力する
  //enum { CaptureTimes = 10 * 60 * 10 };
  enum { CaptureTimes = 10 };
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    vector<long> data;

    int n = urg.capture(data, &timestamp);
    static_cast<void>(n);

    printf("timestamp: %ld\n", timestamp);
#if 0
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
#endif
  }

  // MD コマンドで指定回数だけデータ出力する
  // !!!

  return 0;
}
